inputDirectory = '/Volumes/Greg HD/Yue Oxygen data/Data-Yue-20180731/E5/'
desktopDirectory = '/Users/gfivash/Desktop/'

setwd(inputDirectory)
dir(pattern = '.csv')
file = dir(pattern = '.csv')[1]
pressureFile = dir(pattern = '.csv')[3]
d = read.csv(file)
h = read.csv(pressureFile)
setwd(desktopDirectory)
s = read.csv("hummockE5.csv")

h$time = as.POSIXct(h$time)
d$time = as.POSIXct(d$time)
interval = min(unique(diff(as.POSIXct(d$time))))
origin = as.POSIXct(d$time)[1]
s$time = origin + interval*60*((1:dim(s)[1]) - 1)

tideDown = h$time[diff(h$highTide) == -1]
tideUp = h$time[diff(h$highTide) == 1]

s$tide = 'low'
for(i in 1:length(tideUp)){
  filter = s$time >= tideUp[i] & s$time < tideDown[i]
  s$tide[filter] = 'high'
}

s$tideTime = 0
for(i in 1:length(tideUp)){
  filter = s$time >= tideUp[i] & s$time < tideUp[i + 1]
  if(i == length(tideUp)){
    filter = s$time >= tideUp[i] & s$time <= s$time[length(s$time)]
  }
  s$tideTime[filter] = as.numeric(s$time[filter] - s$time[filter][1])/(60*60)
}
plot(s$tideTime)
lengthOut = 100
highTideLength.hr = 1.8
tideLength = which.min(abs(seq(0, 12, length.out = 100) - highTideLength.hr))

timePolygon = c(0,seq(0, 12, length.out = lengthOut))
tidePolygon = c(-1,rep(6, times = tideLength), rep(-1, times = (lengthOut - tideLength)))

plot(s$oxygen50.cm ~ s$tideTime, pch = '.', cex = 3, ylim = c(6,-1))
polygon(tidePolygon ~ timePolygon, lty = 0, col = alpha('blue',0.2))


tidePolygon = s$tide
tidePolygon[s$tide == 'low'] = -1
tidePolygon[s$tide == 'high'] = 6
plot(s$oxygen50.cm ~ s$time, type = 'l', ylim = c(6,-1))
polygon(tidePolygon ~ s$time, lty = 0, col = alpha('blue',0.2))

s$sedimentShape = 'hummock'
s$experiment = 'E5'

write.csv(s, 'hummockE5.csv', row.names = F)
